<?php $__env->startSection('content'); ?>
<section class="section">
          <div class="section-header">
            <h1>Kelola Layanan</h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
              <div class="breadcrumb-item"><a href="#">Developer</a></div>
              <div class="breadcrumb-item">Services Pulsa</div>
            </div>
          </div>

          <div class="section-body">
          
          	<div class="row">
          		<div class="col-md-12">
          			<div class="card">
		              <div class="card-header">
		                <h4><span>Kelola Layanan Pulsa</span></h4>
		              </div>
		              <div class="card-body">
		              	<?php if(session('success')): ?>

                        <div class="alert alert-success" role="alert">
                            <i class="fa fa-check-circle"></i> <?php echo e(session('success')); ?>

                        </div>

                    	<?php endif; ?>
		              	
		                <div class="float-left">
                      <a href="<?php echo e(url('developer/services_pulsa/add')); ?>" class="btn btn-primary">Tambah Layanan</a>
                    </div>
                      <div class="float-right">
                        <form method="GET">
                          <div class="input-group">
                            <input type="text" class="form-control" placeholder="Search" name="search">
                            <div class="input-group-append">
                              <button class="btn btn-primary"><i class="fas fa-search"></i></button>
                            </div>
                          </div>
                        </form>
                      </div>

                    <div class="clearfix mb-3"></div>

                    <div class="table-responsive">
                      <table class="table table-striped">
                        <tr>
                          <th>#</th>
                          <th>Code</th>
                          <th>Name</th>
                          <th>Category</th>
                          <th>Operator</th>
                          <th>Price</th>
                          <th>Status</th>
                          <th>Provider</th>
                          <th>Action</th>
                        </tr>
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                          <td>
                            <?php echo e($service->id); ?>

                          </td>
                          <td>
                            <?php echo e($service->code); ?>

                          </td>
                          <td>
                            <?php echo e($service->name); ?>

                          </td>
                          <td>
                            <?php echo e($service->category->name); ?>

                          </td>
                          <td>
                            <?php echo e($service->oprator->name); ?>

                          </td>
                          <td>
                            <?php echo e($service->price); ?>

                          </td>
                          <td>
                            <span class="badge badge-<?php echo e(($service->status == 'Active' ? 'success' : 'danger')); ?>"><?php echo e($service->status); ?></span>
                          </td>
                          <td>
                            <?php echo e($service->provider->name); ?>

                          </td>
                          <td>
                            <a href="<?php echo e(url('developer/services_pulsa/edit/'.$service->id)); ?>" class="btn btn-primary">
                              <i class="fa fa-edit"></i>
                            </a>  
                              <form method="POST" class="form-delete">
                                <?php echo method_field('delete'); ?>
                                <?php echo csrf_field(); ?>
                                <input type="hidden" value="<?php echo e($service->id); ?>" name="id">
                                <button type="submit" class="btn btn-danger"><i class="fa fa-trash"></i></button>
                              </form>
                          </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </table>
                    </div> 
                    <div class="mt-2"></div>
                    <?php echo e($services->links()); ?>   
                  </div>
                
                </div>
		              </div>
		            </div>
          		</div>
          	</div>
            
          </div>
        </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Berkc\OneDrive\Masaüstü\smm\zoopedia-master\resources\views\developer\services\pulsa\index.blade.php ENDPATH**/ ?>