<?php $__env->startSection('content'); ?>
<section class="section">
          <div class="section-header">
            <h1>Kelola Layanan</h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
              <div class="breadcrumb-item"><a href="#">Developer</a></div>
              <div class="breadcrumb-item">Services</div>
            </div>
          </div>

          <div class="section-body">
          
          	<div class="row">
          		<div class="col-md-12">
          			<div class="card">
		              <div class="card-header">
		                <h4><span>Kelola Layanan Sosial Media</span></h4>
		              </div>
		              <div class="card-body">
		              	<?php if(session('success')): ?>

                        <div class="alert alert-success" role="alert">
                            <i class="fa fa-check-circle"></i> <?php echo e(session('success')); ?>

                        </div>

                    	<?php endif; ?>
                    <div class="float-left">
                      <form method="GET">
                        <div class="input-group">
                          <input type="text" class="form-control" placeholder="Cari nama layanan" name="search">
                          <div class="input-group-append">                                            
                            <button class="btn btn-primary"><i class="fas fa-search"></i></button>
                          </div>
                        </div>
                      </form>
                    </div>
                    <div class="float-right">
                      <a href="<?php echo e(url('developer/services/add')); ?>" class="btn btn-primary">Tambah</a>
                    </div>
                    <div class="clearfix mb-3"></div>
                    <div class="table-responsive">
  		                <table class="table table-striped table-md">
                          <tr>                          
                            <th>ID</th>
                            <th>Nama</th>
                            <th>Kategori</th>
                            <th>Min</th>
                            <th>Max</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Action</th>
                          </tr>
                          <?php $__currentLoopData = $service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td><?php echo e($data->id); ?></td>
                            <td><?php echo e($data->name); ?></td>
                            <td><?php echo e($data->category->name); ?></td>
                            <td><?php echo e($data->min); ?></td>
                            <td><?php echo e($data->max); ?></td>
                            <td>Rp <?php echo e($data->price + $data->keuntungan); ?></td>
                            <td><span class="badge badge-<?php echo e($data->status=='Active' ? 'success' : 'danger'); ?>"><?php echo e($data->status); ?></span></td>
                            <td style="display: inline-block;">
                            	<a href="<?php echo e(url('developer/services/detail/'.$data->id)); ?>" class="btn btn-secondary"><i class="fa fa-eye"></i></a>
                            	<a href="<?php echo e(url('developer/services/edit/'.$data->id)); ?>" class="btn btn-primary"><i class="fa fa-edit"></i></a>
                            	<form method="POST" class="form-delete">
                                  <?php echo method_field('delete'); ?>
                                  <?php echo csrf_field(); ?>
                                  <input type="hidden" value="<?php echo e($data->id); ?>" name="id">
                                  <button type="submit" class="btn btn-danger" data-toggle="tooltip" data-placement="top" title="Saran: Jangan hapus layanan, karena akan menghapus seluruh data order dengan layanan ini. Lebih baik nonaktifkan layanan">
                                  	<i class="fa fa-trash"></i>
                                  </button>
                                </form>

                            </td>
                          </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </table>
                    </div>
                    <?php echo e($service->links()); ?>

		              </div>
		            </div>
          		</div>
          	</div>
            
          </div>
        </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Berkc\OneDrive\Masaüstü\smm\zoopedia-master\resources\views\developer\services\index.blade.php ENDPATH**/ ?>