<?php $__env->startSection('content'); ?>
<section class="section">
          <div class="section-header">
            <h1>New order</h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
              <div class="breadcrumb-item"><a href="#">Order</a></div>
              <div class="breadcrumb-item"><a href="#">Sosial Media</a></div>
				<div class="breadcrumb-item">Riwayat Pemesanan</div>
            </div>
          </div>

          <div class="section-body">
          
          	<div class="row">
          		<div class="col-12">
          			<div class="card">
		              <div class="card-header">
		                <h4><span>Riwayat Pemesanan</span></h4>
		              </div>
		             
		              <div class="card-body">
		              	<?php if(session('success')): ?>
	                        <div class="alert alert-primary" role="alert">
	                            <i class="fa fa-check-circle"></i> <?php echo session('success'); ?>

	                        </div>
		              	<?php elseif(session('danger')): ?>
	                        <div class="alert alert-danger" role="alert">
	                            <i class="fa fa-exclamation-circle"></i> <?php echo e(session('danger')); ?>

	                        </div>
	                    <?php endif; ?>
	                    <?php if($errors->has('quantity')): ?>
		                    	<div class="alert alert-danger" role="alert">
		                            <i class="fa fa-exclamation-circle"></i> <?php echo e($errors->first('quantity')); ?>

		                        </div>
						<?php endif; ?>
						<div class="float-right">
	                        <form>
	                          <div class="input-group">
	                            <input type="text" class="form-control" placeholder="Cari order id atau target" name="search">
	                            <div class="input-group-append">                                            
	                              <button class="btn btn-primary"><i class="fas fa-search"></i></button>
	                            </div>
	                          </div>
	                        </form>
                      	</div>				
                      	<div class="clearfix mb-3"></div>
						<div class="table-responsive">
							<table class="table table-striped table-md">
								<tr>
									<th>ID</th>
									<th>Service</th>
									<th>Target</th>
									<th>Quantity</th>
									<th>Start/Remains</th>
									<th>Price</th>
									<th>Status</th>
									<th>Refund</th>
									<th>Action</th>
								</tr>
									<?php $__currentLoopData = $order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($data_order->id); ?></td>
										<td><?php echo e($data_order->service->name); ?></td>
										<td><?php echo e($data_order->target); ?></td>
										<td> <?php echo e($data_order->quantity); ?></td>
										<td><?php echo e($data_order->start_count); ?>/<?php echo e($data_order->remains); ?></td>
										<td>Rp <?php echo e(number_format($data_order->price)); ?></td>
										<td><span class="badge badge-<?php echo e(($data_order->status === 'Pending') ? 'warning' : (($data_order->status == 'Error' || $data_order->status == 'Partial') ? 'danger' : (($data_order->status == 'Processing') ? 'primary' : 'success'))); ?>"><?php echo e($data_order->status); ?></span></td>
										<td>
											<span class="badge badge-<?php echo e(($data_order->refund==0) ? 'danger' : 'success'); ?>">
												<?php if($data_order->refund == 0): ?> 
													<i class="fa fa-times"></i>
												<?php else: ?>
													<i class="fa fa-check"></i>
												<?php endif; ?>
											</span>
										</td>
										<td>
											<a href="#" class="btn btn-secondary">Detail</a>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</table>
						</div>
						<div class="float-right">
							<?php echo e($order->links()); ?>

						</div>
							                
		              </div>
		            
		            </div>
          		</div>
          		<div class="col-md-4">
          			
          		</div>
          	</div>
            
          </div>
        </section>




<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Berkc\OneDrive\Masaüstü\smm\zoopedia-master\resources\views\order\sosmed\history.blade.php ENDPATH**/ ?>