<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title><?php echo e(env('APP_NAME')); ?></title>

  <!-- General CSS Files -->
  <link rel="stylesheet" href="<?php echo e(asset('modules/bootstrap/css/bootstrap.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('modules/fontawesome/css/all.min.css')); ?>">

  <!-- CSS Libraries -->
  <link rel="stylesheet" href="<?php echo e(asset('modules/jqvmap/dist/jqvmap.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('modules/summernote/summernote-bs4.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('modules/owlcarousel2/dist/assets/owl.carousel.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('modules/owlcarousel2/dist/assets/owl.theme.default.min.css')); ?>">

  <!-- Template CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('css/components.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">


<!-- /END GA --></head>
<script type="text/javascript" >
  
</script>
<body>
  <div id="app">
    <div class="main-wrapper main-wrapper-1">
      <div class="navbar-bg"></div>
      <nav class="navbar navbar-expand-lg main-navbar">
          <ul class="navbar-nav mr-auto">
            <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg"><i class="fas fa-bars"></i></a></li>
            <li><a href="#" data-toggle="search" class="nav-link nav-link-lg d-sm-none"><i class="fas fa-search"></i></a></li>
          </ul>
        
        <ul class="navbar-nav navbar-right">
          
          <?php if(Auth::check()): ?>
          <li class="dropdown dropdown-list-toggle"><a href="#" data-toggle="dropdown" class="nav-link notification-toggle nav-link-lg beep"><i class="far fa-bell"></i></a>
            <div class="dropdown-menu dropdown-list dropdown-menu-right">
              <div class="dropdown-header">Berita
                  
              </div>
              <div class="dropdown-list-content dropdown-list-icons">
                <?php $__currentLoopData = config('news'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(url('/news')); ?>" class="dropdown-item">
                    <?php if($news->type == 'Info'): ?>
                    <div class="dropdown-item-icon bg-info text-white">
                      <i class="fas fa-bell"></i>
                    <?php elseif($news->type == 'Service'): ?>
                    <div class="dropdown-item-icon bg-success text-white">
                      <i class="fas fa-file-invoice   "></i>
                    <?php elseif($news->type == 'Maintenance'): ?>
                    <div class="dropdown-item-icon bg-danger text-white">
                      <i class="fas fa-exclamation-triangle"></i>
                    <?php else: ?>
                    <div class="dropdown-item-icon bg-primary text-white">
                      <i class="fas fa-info"></i>
                    <?php endif; ?>
                  </div>
                  <div class="dropdown-item-desc">
                    <?php echo e($news->title); ?>

                    <div class="time"><?php echo e($news->created_at->diffForHumans()); ?></div>
                  </div>
                </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
              <div class="dropdown-footer text-center">
                <a href="<?php echo e(url('/news')); ?>">View All <i class="fas fa-chevron-right"></i></a>
              </div>
            </div>
          </li>
          
          <li class="dropdown"><a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user">
            <img alt="image" src="<?php echo e(asset('img/users/'.auth()->user()->photo)); ?>" class="rounded-circle mr-1 img-header">
            <div class="d-sm-none d-lg-inline-block">Hi, <?php echo e(auth()->user()->name); ?></div></a>
            <div class="dropdown-menu dropdown-menu-right">
              <div class="dropdown-title">Logged in 
                <?php echo e(config('last_login')->created_at->diffForHumans()); ?>

              </div>
              <a href="<?php echo e(url('/activity')); ?>" class="dropdown-item has-icon">
                <i class="fas fa-bolt"></i> Activities
              </a>
              <a href="<?php echo e(url('/users/settings')); ?>" class="dropdown-item has-icon">
                <i class="fas fa-cog"></i> Settings
              </a>
              <div class="dropdown-divider"></div>
              <a href="#" class="dropdown-item has-icon text-danger" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                <i class="fas fa-sign-out-alt"></i> Logout
              </a>
              <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                  <?php echo csrf_field(); ?>
              </form>
            </div>
          </li>
          <?php endif; ?>
        </ul>
      </nav>
      <div class="main-sidebar sidebar-style-2">
        <aside id="sidebar-wrapper">
          <div class="sidebar-brand">
            <a href="index.html">ZOOPEDIA</a>
          </div>
          <div class="sidebar-brand sidebar-brand-sm">
            <a href="index.html">St</a>
          </div>
          <ul class="sidebar-menu">
            <li class="menu-header">Main navigation</li>
            <li><a class="nav-link" href="/"><i class="fas fa-fire"></i> <span>Dashboard</span></a></li>

            <?php if(auth()->user()->level == 'Developer'): ?>
            <li class="dropdown">
              <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-unlock-alt "></i> <span>Developer Menu</span></a>
              <ul class="dropdown-menu">
                <li><a class="nav-link" href="<?php echo e(url('developer/users')); ?>">Kelola Pengguna</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/orders/sosmed')); ?>"> Kelola Pesanan Sosmed</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/orders/pulsa')); ?>"> Kelola Pesanan Pulsa</a></li>
                <li><a class="nav-link" href="<?php echo e(route('services_cat')); ?>"> Kelola Kategori Sosmed</a></li>
                <li><a class="nav-link" href="<?php echo e(route('services_cat_pulsa')); ?>"> Kelola Kategori Pulsa</a></li>
                <li><a class="nav-link" href="<?php echo e(route('dev_services')); ?>"> Kelola Layanan Sosmed</a></li>
                <li><a class="nav-link" href="<?php echo e(route('dev_services_pulsa')); ?>"> Kelola Layanan Pulsa</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/deposit')); ?>"> Kelola Deposit</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/deposit/method')); ?>"> Kelola Metode Deposit</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/news')); ?>"> Kelola Berita</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/tickets')); ?>"> Kelola Tiket</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/providers')); ?>"> Kelola Provider</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/staff')); ?>"> Kelola Staff</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/invitation_code')); ?>"> Kelola Kode Undangan</a></li>
                <li><a class="nav-link" href="<?php echo e(url('developer/activity')); ?>"> Log Aktifitas</a></li>
                
              </ul>
            </li>
            <?php endif; ?>
            <?php if(auth()->user()->level != 'Member'): ?>
            <li class="dropdown">
              <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-unlock-alt "></i> <span>Staff Menu</span></a>
              <ul class="dropdown-menu">
                <li><a class="nav-link" href="<?php echo e(url('staff/add_user')); ?>"> Tambah User</a></li>
                <li><a class="nav-link" href="<?php echo e(url('staff/voucher')); ?>"> Kode Voucher</a></li>
              </ul>
            </li>
            <?php endif; ?>
            <li class="dropdown">
              <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-shopping-cart"></i> <span>Sosial Media</span></a>
              <ul class="dropdown-menu">
                <li><a class="nav-link" href="<?php echo e(route('order_sosmed')); ?>">Pemesanan baru</a></li>
                <li><a class="nav-link" href="<?php echo e(route('sosmed_history')); ?>"> Riwayat Pemesanan</a></li>
                <!-- <li><a class="nav-link" href="<?php echo e(url('order/sosmed/statistic')); ?>">Statistik Order</a></li> -->
              </ul>
            </li>
            <li class="dropdown">
              <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-shopping-cart"></i> <span>Pulsa & PPOB</span></a>
              <ul class="dropdown-menu">
                <li><a class="nav-link" href="<?php echo e(route('order_pulsa')); ?>">Pemesanan baru</a></li>
                <li><a class="nav-link" href="<?php echo e(route('order_pulsa_history')); ?>"> Riwayat Pemesanan</a></li>
                <!-- <li><a class="nav-link" href="<?php echo e(url('order/statistic')); ?>">Statistik Order</a></li> -->
              </ul>
            </li>
            <li class="dropdown">
              <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-fire"></i> <span>Lainnya</span></a>
              <ul class="dropdown-menu">
                <li><a class="nav-link" href="<?php echo e(url('news')); ?>">Berita</a></li>
                <li><a class="nav-link" href="<?php echo e(url('hall_of_fame')); ?>">Top 10</a></li>
                <li><a class="nav-link" href="<?php echo e(url('activity')); ?>"> Riwayat Aktifitas</a></li>
                <li><a class="nav-link" href="<?php echo e(url('balance_usage')); ?>">Penggunaan Saldo</a></li>
                <li><a class="nav-link" href="<?php echo e(url('voucher')); ?>">Kode Voucher</a></li>
              </ul>
            </li>
            <li>
              <a href="<?php echo e(url('ticket')); ?>" class="nav-link " ><i class="fas fa-envelope"></i> <span>Tiket</span></a>
            </li>
            <li class="dropdown">
              <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-dollar-sign "></i> <span>Deposit</span></a>
              <ul class="dropdown-menu">
                <li><a class="nav-link" href="<?php echo e(url('deposit/new')); ?>">Deposit Baru</a></li>
                <li><a class="nav-link" href="<?php echo e(url('deposit/history')); ?>">Riwayat Deposit</a></li>
              </ul>
            </li>
            <li class="dropdown">
              <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-tag"></i> <span>Daftar layanan</span></a>
              <ul class="dropdown-menu">
                <li><a class="nav-link" href="<?php echo e(url('price/sosmed')); ?>">Sosial Media</a></li>
                <li><a class="nav-link" href="<?php echo e(url('price/pulsa')); ?>">Pulsa & PPOB</a></li>
              </ul>
            </li>
            <li class="dropdown">
              <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-random"></i> <span>API Dokumentasi</span></a>
              <ul class="dropdown-menu">
                <li><a class="nav-link" href="<?php echo e(url('api/sosmed/doc')); ?>">Sosial Media</a></li>
                <li><a class="nav-link" href="<?php echo e(url('api/pulsa/doc')); ?>">Pulsa & PPOB</a></li>
              </ul>
            </li>
            <li><a href="<?php echo e(url('/contact')); ?>" class="nav-link"><i class="fas fa-users"></i><span>Kontak Admin</span></a></li>
            <li><a href="<?php echo e(url('/users/settings')); ?>" class="nav-link"><i class="fas fa-cogs"></i><span>Settings</span></a></li>

        
        </aside>
      </div>

      <!-- Main Content -->
      <div class="main-content">
        <?php echo $__env->yieldContent('content'); ?>
      </div>
      <footer class="main-footer">
        <div class="footer-left">
          Copyright &copy; <?php echo e(date('Y')); ?> <div class="bullet"></div> Build with ♥ by <a href="https://www.zuramai.net/">Zuramai Network</a>
        </div>
        <div class="footer-right">
          
        </div>
      </footer>
    </div>
  </div>

  <!-- General JS Scripts -->
  <script src="<?php echo e(asset('modules/jquery.min.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/popper.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/tooltip.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/bootstrap/js/bootstrap.min.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/nicescroll/jquery.nicescroll.min.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/moment.min.js')); ?>"></script>
  <script src="<?php echo e(asset('js/stisla.js')); ?>"></script>
  
  <!-- JS Libraies -->
  <script src="<?php echo e(asset('modules/jquery.sparkline.min.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/chart.min.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/owlcarousel2/dist/owl.carousel.min.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/summernote/summernote-bs4.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/chocolat/dist/js/jquery.chocolat.min.js')); ?>"></script>

<?php if(url()->current() == url('/') || url()->current() == url('/') || url()->current() == url('/home')): ?>
  <script type="text/javascript">
    var data_sosmed = new Array(0,0,0,0,0,0,0,0,0,0,0,0)
    <?php $__currentLoopData = $order_sosmed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sosmed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

    data_sosmed[<?php echo e($sosmed->month); ?>] = <?php echo e($sosmed->total); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    var data_pulsa = new Array(0,0,0,0,0,0,0,0,0,0,0,0)
    <?php $__currentLoopData = $order_pulsa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pulsa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

    data_pulsa[<?php echo e($pulsa->month); ?>] = <?php echo e($pulsa->total); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    console.log(data_pulsa)
  </script>
<?php endif; ?>

  <!-- Page Specific JS File -->

  <script src="<?php echo e(asset('js/page/index.js')); ?>"></script>
  <script src="<?php echo e(asset('modules/sweetalert/sweetalert.min.js')); ?>"></script>
  <?php echo $__env->make('sweet::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!-- Template JS File -->
  <script src="<?php echo e(asset('js/scripts.js')); ?>"></script>
  <script src="<?php echo e(asset('js/function.js')); ?>"></script>
  <script src="<?php echo e(asset('js/custom.js')); ?>"></script>
  <script src="https://cdn.rawgit.com/google/code-prettify/master/loader/run_prettify.js"></script>
  
  <script type="text/javascript">
        


  $(document).ready(function(){
    var csrf_token = $("meta[name='csrf-token']").attr('content');
    $('#category').change(function(){
        console.log('a')
        var cat = $('#category').val();
        $.ajax({
            url: "<?php echo e(url('order/sosmed/ajax/get_service')); ?>",
            type: 'POST',
            data: {
                "_token": csrf_token,
                "cat_id": cat
            },
            success:function(result){
                $('#service').html(result)
            }
        }) 
    });
    $('#service').change(function(){
        var service = $('#service').val();
        $.ajax({
            url: "<?php echo e(url('order/sosmed/ajax/get_service_data')); ?>",
            type: 'POST',
            data: {
                "_token": csrf_token,
                "sid": service
            },
            success:function(result){
                $('#information').html(result)
            }
        })
        $.ajax({
            url: "<?php echo e(url('order/sosmed/ajax/get_price')); ?>",
            type: 'POST',
            data: {
                "_token": csrf_token,
                "sid": service
            },
            success:function(result){
                $('#price').val(result)
            }
        })

        $.ajax({
          url: "<?php echo e(url('order/sosmed/ajax/check_sosmed')); ?>",
          type: 'POST',
          data: {
            "_token": csrf_token,
            "sid": service
          },
          success: function(result) {
            if(result == 'custom_comment') {
              $('#custom_comment').css('display','block');
              $('#quantity').attr('readonly','true');
              $('#t_custom_comment').keyup(function() {
                var text = $("#t_custom_comment").val();   
                var lines = text.split(/\r|\r\n|\n/);
                var count = lines.length;
                $('#quantity').val(count);
                var total = $('#price').val() / 1000 * count
                $('#total').val(total);
              });
            }else if(result == 'likes_comment') {
              $('#likes_comment').css('display','block');
            }
          }
        });
    })
    $('#quantity').keyup(function(){
        var qty = $('#quantity').val();
        var price = $('#price').val();

        var total = price/1000 * qty;

        $('#total').val(total)
    })
    $('#cancel_deposit').click(function(){
       
      cancel_deposit($(this).attr('data-delete'));
    })

    $('#category_pulsa').change(function() {
      var category = $('#category_pulsa').val();
      var service = $('#service_pulsa');
      var operator = $('#operator_pulsa');
        // console.log("success");
      $.ajax({
        url: "<?php echo e(url('order/pulsa/ajax/get_service_pulsa')); ?>",
        type: 'POST',
        data: {
            "_token": csrf_token,
            "id": category
        },
        success: function(result) {
          operator.html(result)
        }
      });
    });

    $('#operator_pulsa').change(function() {
      var category = $('#category_pulsa').val();
      var operator = $('#operator_pulsa').val();
      var service = $('#service_pulsa');

      $.ajax({
        url: "<?php echo e(url('order/pulsa/ajax/get_type_pulsa')); ?>",
        type: 'POST',
        data: {
            "_token": csrf_token,
            "id": operator
        },
        success: function(result) {
          service.html(result)
        }
      });
    });

    $('#service_pulsa').change(function() {
      var service_pulsa = $('#service_pulsa').val();
      var price = $('#total');
      $.ajax({
        url: "<?php echo e(url('order/pulsa/ajax/get_price_pulsa')); ?>",
        type: 'POST',
        data: {
            "_token": csrf_token,
            "id": service_pulsa
        },

        success: function(result) {
          price.val(result)
        }

      });
    });

    $('#type').change(function() {

      var type = $('#type').val();
      var method = $('#method');
      var newType = "AUTO";
      if(type == "Otomatis") 
        newType = "AUTO"
      else if(type == "Manual")
        newType = "MANUAL"

      $.ajax({
        type: "POST",
        url: "<?php echo e(url('deposit/get_method')); ?>",
        data: {
          "_token": csrf_token,
          "type": newType
        },
        success:function(result) {
          console.log(result);
          method.html(result);
        }
      });
    });
    $('#method').change(function() {
      var method = $('#method').val();
      $.ajax({
        url: "<?php echo e(url('deposit/get_rate')); ?>",
        method: 'POST',
        data: {
          "_token": csrf_token,
          "method": method
        },
        success:function(result) {
          $('#rate_deposit').val(result);
        }

      })
    });

    $('#quantity_deposit').keyup(function() {
      var quantity = $('#quantity_deposit').val();
      var rate = $('#rate_deposit').val();
      var get_balance = $('#get_balance'); 

      var final = quantity * rate;
      get_balance.val(final)
    }); 
  })
        


           
        
    </script>
</body>
</html><?php /**PATH C:\Users\Berkc\OneDrive\Masaüstü\smm\zoopedia-master\resources\views\layouts\sidebar.blade.php ENDPATH**/ ?>