<?php $__env->startSection('content'); ?>
<section class="section">
          <div class="section-header">
            <h1>Kelola Order</h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
              <div class="breadcrumb-item"><a href="#">Developer</a></div>
              <div class="breadcrumb-item">Services</div>
            </div>
          </div>

          <div class="section-body">
          
          	<div class="row">
          		<div class="col-md-12">
          			<div class="card">
		              <div class="card-header">
		                <h4><span>Kelola Order</span></h4>
		              </div>
		              <div class="card-body">
                    <div class="float-left">
                          <form method="GET">
                            <div class="input-group">
                              <input type="text" class="form-control" placeholder="Cari ID order atau nomor tujuan" name="search">
                              <div class="input-group-append">                                            
                                <button class="btn btn-primary"><i class="fas fa-search"></i></button>
                              </div>
                            </div>
                          </form>
                        </div>
                        <div class="clearfix mb-3"></div>
		              	<?php if(session('success')): ?>

                        <div class="alert alert-success" role="alert">
                            <i class="fa fa-check-circle"></i> <?php echo e(session('success')); ?>

                        </div>

                    	<?php endif; ?>
                          <div class="table-responsive">
                                <table class="table table-striped table-md">
                                <tr>
                                    <th>ID</th>
                                    <th>POID</th>
                                    <th>User</th>
                                    <th>Layanan</th>
                                    <th>Harga</th>
                                    <th>Target</th>
                                    <th>SN</th>
                                    <th>Status</th>
                                    <th>Refund</th>
                                    <th>Action</th>
                                </tr>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($order->id); ?></td>
                                    <td><?php echo e($order->poid); ?></td>
                                    <td><?php echo e($order->user->name); ?></td>
                                    <td><?php echo e($order->service->name); ?></td>
                                    <td><?php echo e($order->price); ?></td>
                                    <td><?php echo e($order->data); ?></td>
                                    <td><?php echo e($order->sn); ?></td>
                                    <td><span class="badge badge-<?php echo e(($order->status === 'Pending') ? 'warning' : (($order->status == 'Error' || $order->status == 'Partial') ? 'danger' : (($order->status == 'Processing') ? 'primary' : 'success'))); ?>"><?php echo e($order->status); ?></span></td>
                                    <td>
                                      <span class="badge badge-<?php echo e(($order->refund==0) ? 'danger' : 'success'); ?>">
                                      <?php if($order->refund == 0): ?> 
                                        <i class="fa fa-times"></i>
                                      <?php else: ?>
                                        <i class="fa fa-check"></i>
                                      <?php endif; ?>
                                    </span>
                                    </td>
                                    <td style="display: inline-block;">
                                        <a href="<?php echo e(url('developer/orders/pulsa/edit/'.$order->id)); ?>" class="btn btn-primary"><i class="fa fa-edit"></i></a>
                                    

                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                          </div>
		              </div>
		            </div>
          		</div>
          	</div>
            
          </div>
        </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Berkc\OneDrive\Masaüstü\smm\zoopedia-master\resources\views\developer\orders\pulsa\index.blade.php ENDPATH**/ ?>